#ifndef SOUND_H
#define SOUND_H
//
// Mike Johnson	iReady
//   
#define DOS

typedef int				HANDLE;
typedef	unsigned int	WORD;
typedef unsigned long	DWORD;  

#ifdef DOS
typedef char _huge *	HPSTR;	
#else 
typedef char	*		HPSTR;
#endif                        



typedef struct { 
    WORD  wFormatTag; 
    WORD  nChannels; 
    DWORD nSamplesPerSec; 
    DWORD nAvgBytesPerSec; 
    WORD  nBlockAlign; 
    WORD  wBitsPerSample; 
    WORD  cbSize; 
} WAVEFORMATEX; 


typedef struct SOUND_
{   
	//
	//  Wav Data 
	//  
	HANDLE          dataHandle;
	HPSTR           data;       
	DWORD           data_size;     
	DWORD			odata_size;    
	//
	// Prefiltered Data
	//                 
	HANDLE			pfdataHandle;
	HPSTR			pfdata;
	DWORD			pfdata_size;
	//
	// Compressed Data
	//
	HANDLE			cdataHandle;
	HPSTR			cdata;
	DWORD			cdata_size;
	//
	// Uncompressed Data
	//
	HANDLE			ucdataHandle;
	HPSTR			ucdata; 
	DWORD			ucdata_size; 
	//  
	// Original Format
	//
	WAVEFORMATEX	oformat; 
	//
	// New Format
	//           
	WAVEFORMATEX	format;
}SOUND;  
   

#endif   
   