//------------------------------------------------------------------------------
// downsmp.c  	- convert a .wav file to a raw, normalized
//		ASCII file.
//
// Mike Johnson iReady
//------------------------------------------------------------------------------          
#include <stdio.h>  
//#include "downsamp.h"
#include "wave.h"

//      											
// ffindstr(file,string) - find string in file.  !0=found 0=notfound;
//
int
ffindstr(file,string)
FILE	*file;
char	*string;
{
int	len,ch;
int	pos=0;
int	ret=1;

	len=strlen(string);
	
	while(pos<len)
	{                  
		if((ch=fgetc(file))==EOF)
		{
			ret=0;
			break;
		}
		if(ch==string[pos])
			pos++;	      
		else
			pos=0;	
	}             
	return(ret);
}
        

unsigned long
getdw(file)
FILE	*file;
{
char			*ptr;
unsigned long	store;

	ptr=(char *)&store;
	
	*ptr++=fgetc(file);
	*ptr++=fgetc(file);
	*ptr++=fgetc(file);
	*ptr++=fgetc(file);
	
	return(store);
}


//
// get 
//
int
getraw(file,buffer,len)
FILE	*file;        
char	*buffer;
int		len;
{
int				i;
            
	for(i=0;i<len;i++) 
	{
	 	if(EOF==	(buffer[i]=fgetc(file)))
	 		return(i);
    }       
	return(i);
}


//
// openwave() - opens a wave file and leave the file pointer pointing at
//				the raw data.  Wave info is placed in the structure info.
//
unsigned long
openwave(file,info)
FILE			*file;
WAVEFORMATEX	*info;
{  
long	temp;
	//
	// Search for WAVE
	// 
	if(ffindstr(file,"WAVE")!=0)
	{
		 if(ffindstr(file,"fmt ")!=0)
         {    
         	// Eat header length
         	temp=getdw(file);
         	//
         	//
         	//                             
         	if(temp>sizeof(WAVEFORMATEX))
         		temp=sizeof(WAVEFORMATEX);
         	if(getraw(file,info,temp)<temp)
         		return(0);
         	//
         	// Read the Format Chunk
         	//         	  
/*         	info->wFormatTag=getw(file);
         	info->nChannels=getw(file);
         	info->nSamplesPerSec=getdw(file);
         	info->nAvgBytesPerSec=getdw(file);
         	info->nBlockAlign=getw(file);
         	info->wBitsPerSample=getw(file);
         	info->cbSize=getw(file);	
*/         	
         	//
         	// We want to leave with the file pointer pointing at the
         	// waveform data.
         	//
         	if(ffindstr(file,"data"))
         	{
					return(getdw(file));
				//fread(&temp,sizeof(long),1,file);	
		         //	return(temp);
         	}
         }
	}                 
	return(0);
}

              
main(argc,argv)
int 	argc;
char 	**argv;
{   
WAVEFORMATEX	info;
unsigned long	size;
char			*filename;
int				ch;    
char			buff;
         
	if(argc==1)
	{
		;
	}         
	else if (argc==2)
	{   
		if (!freopen(filename = argv[1], "rb", stdin)) 
		{
 			printf("\nError opening file %s.\n",filename);
  			exit(1);
  		}
    }
	else
	{             							
		printf("\nCorrect usage is: downsamp [file]\n");
	}										
	
	
	if((size=openwave(stdin,&info)))
	{                               				
		if(info.wFormatTag==WAVE_FORMAT_PCM)
		{
			//printf("wave file size = %lu\n",size);
			//printf("Sample Rate =%ld\n",info.nSamplesPerSec);
			//printf("num chan = %d\n",info.nChannels);
			Normalize_Sound(stdin,stdout,&info,size);
		}    							
		else
			printf("ERROR: .wav file is not in PCM format.\n");
	}
	else       
	{       
		printf("\nError Reading %s, corrupt or not .wav format.\n",filename);
		exit(1);
	}
	exit(0);
}