//       												
// asc2wav.c - convert asc to 8khz mono wav		Mike Johnson iReady
//                               
#include <stdio.h>
#include <string.h>
#include "wave.h"
//
// readln_from_a_file
// 
int
readln_from_a_file(fp, line, size)
FILE    *fp;
char    *line;
int     size;
{
        char *p;
 
        do
                p = fgets( line, size, fp );
        while( ( p != NULL ) && ( *line == '#') );

        if( p == NULL )
                return( 0 );

        if (strchr(line, '\n'))
          *strchr(line, '\n') = '\0';
        if (strchr(line, '\r'))
          *strchr(line, '\r') = '\0';
        return( 1 );
}
 
 
//
//
//
main(argc,argv)
int 	argc;
char 	**argv;
{                    
FILE			*sfile;
char			line[25];
char			*filename;
WORD			j;
BYTE			c,data; 
unsigned int	cc;
unsigned long   len=0;
DWORD			i;  

         
    if (argc==2)
	{   
		sfile=fopen(filename=argv[1],"r");
		if (!sfile) 
		{
 			printf("\nError opening file %s.\n",filename);
  			exit(1);
  		}
    }
	else
	{             							
		printf("\nCorrect usage is: asc2wav [file]\n");
		printf("	File Must Be Specified.\n");
		exit(1);
	}										
	//
	// First calculate file size
	//      
	len=0;                    
	while(readln_from_a_file(sfile, line, 10))
	{
		len++;	
	}	
    rewind(sfile); 
	//
	// Write the Wave header
	//
	//52 49 46 46 L0 L1 L2 L3 57 41 56 45 66 6d 74 20 10 00 00 00 01 00 01 00 40
	//1f 00 00 40 1f 00 00 01 00 08 00 64 61 74 64 S0 S1 S2 S3 
	//
	//
	fprintf(stdout,"RIFF");
	i=len+0x24;    
#ifdef SPARC
	i=swapl(i);
#endif	
	fwrite(&i,sizeof(DWORD),1,stdout);
	//
	// Write Wave header
	//
	fprintf(stdout,"WAVEfmt ");
	//
	// Write wave header length (0x10)
	//
	i=0x10;
#ifdef SPARC
	i=swapl(i);
#endif		
	fwrite(&i,sizeof(DWORD),1,stdout);  
	//
	// Write tag (1)
	//                             
	j=0x01;  
#ifdef SPARC
	j=swap(j);
#endif		
	fwrite(&j,sizeof(WORD),1,stdout);
	//
	// Write Number of channels (1)
	//                             
	j=0x01;
#ifdef SPARC
	j=swap(j);
#endif		
	fwrite(&j,sizeof(WORD),1,stdout);
	//
	// Write sample rate (0x1f40)
	//
	i=0x1f40; 
#ifdef SPARC
	i=swapl(i);
#endif	
	fwrite(&i,sizeof(DWORD),1,stdout);
	//
	// Write avg bytes sec (0x1f40)
	//
	i=0x1f40;
#ifdef SPARC
	i=swapl(i);
#endif	
	fwrite(&i,sizeof(DWORD),1,stdout);
	//
	// Block align (1)
	//                             
	j=0x01; 
#ifdef SPARC
	j=swap(j);
#endif		
	fwrite(&j,sizeof(WORD),1,stdout);			
	//
	// Bits a sample(8)
	//                             
	j=0x08;
#ifdef SPARC
	j=swap(j);
#endif		
	fwrite(&j,sizeof(WORD),1,stdout);			
	//
	// Write Data
	//           
	fprintf(stdout,"data");
	//
	// Data size
	//
	i=len;
#ifdef SPARC
	i=swapl(i);
#endif		
	fwrite(&i,sizeof(DWORD),1,stdout);		
	//
	// Write the wave Data
	//  
	//fwrite(data,sizeof(char),len,sfile);
	    
	for(i=0;i<len;i++)
	{                 
		readln_from_a_file(sfile, line, 10);			
		sscanf(line,"%x",&cc);
		c=cc;
	    fwrite(&c,sizeof(BYTE),1,stdout);
	}
	fclose(sfile);   
	return(0);
}