//
// adpcm21c.c - compress adpcm 2:1	- mike johnson
//                               
#include <stdio.h>
#include <string.h>
//
// step size and index for 2:1 ADPCM compression
//								
int		step_count21=4;
int		step_size21[]		= {	0x04, 0x08, 0x10, 0x20};
int		step_index21[4][8]	= {	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
								0x01, 0x03, 0x05, 0x07, 0x09, 0x0b, 0x0d, 0x0f,
								0x02, 0x06, 0x0a, 0x0e, 0x12, 0x16, 0x1a, 0x1e,
								0x04, 0x0c, 0x14, 0x1c, 0x24, 0x2c, 0x34, 0x3c};

int		step_table21[4][8]	= { 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08,
								0xf8, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08,								
								0xf8, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08,
								0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
//
// readln_from_a_file
// 
int
readln_from_a_file(fp, line, size)
FILE    *fp;
char    *line;
int     size;
{
        char *p;
 
        do
                p = fgets( line, size, fp );
        while( ( p != NULL ) && ( *line == '#') );

        if( p == NULL )
                return( 0 );

        if (strchr(line, '\n'))
          *strchr(line, '\n') = '\0';
        if (strchr(line, '\r'))
          *strchr(line, '\r') = '\0';
        return( 1 );
}
 
 
//
//
//
main(argc,argv)
int 	argc;
char 	**argv;
{                    
char			line[25];
char			*filename;
unsigned char	data; 
unsigned int	c;
int				cp=0;
int				ref_sample=0;
int				row_index=0;
int				step_delta=0;	
int				chunk=0;   
int				sign=0;
int				delta=0;  
         
	if(argc==1)
	{
		;
	}         
	else if (argc==2)
	{   
		if (!freopen(filename = argv[1], "rb", stdin)) 
		{
 			printf("\nError opening file %s.\n",filename);
  			exit(1);
  		}
    }
	else
	{             							
		printf("\nCorrect usage is: adpcm21c [file]\n");
		printf("	If file is not specified adpcm21c will use stdin.");  
		exit(1);
	}										

    //
    // Send first sample through untouched
    //  									                                  
    if(!readln_from_a_file(stdin, &line, 20))
    	exit(0);
    sscanf(line,"%x",&c);
    printf("%.2x\n",c);	
    //
    // Initialize Compressor
    //                      
    ref_sample=c;
    //
    // Start readling lines, each line should contain one sample
    //		
    while(1)
    {
	   if(readln_from_a_file(stdin, &line, 20))
	    	sscanf(line,"%x",&c);
    	   else 
		break;

	delta=c-ref_sample;   
				
	cp=0;       
        if(delta>=0)
        	sign=0;
        else
        	sign=0x08;	                 
		//      
	  	delta=abs(delta);		 
		if(delta >= step_size21[row_index])
		{
			cp|=0x4;
			delta-=step_size21[row_index];
		}                            
		//
		if(delta >= (step_size21[row_index]>>1))
		{
			cp|=0x2;
			delta-=(step_size21[row_index]>>1);
		}	 
		//
        if(delta >= (step_size21[row_index]>>2))
    	{       
    		cp|=0x1;
    	}
	    //
        // calc new ref sample.
		//
		if(sign)
			ref_sample-=step_index21[row_index][cp];
		else
			ref_sample+=step_index21[row_index][cp];
		//
		// Adjust Row Index
		//
		if(step_table21[row_index][cp]==0x08)
			row_index++;
		else if(step_table21[row_index][cp]==0xf8)
			row_index--;
		//
		// Clip Row Index
		//	
		if(row_index<0)
			row_index=0;
		if(row_index>(step_count21-1))
			row_index=step_count21-1;
		//
		// Store info in chunk
		//                    
		data=(data<<4) | cp | sign;
		chunk++;
		if(chunk>=2)
		{
			//
			// Flush Chunk
			//
	    		printf("%.2x\n",data);			
			chunk=0; 
		}				
	}
}
