//
// G726Compress.c - Mike Johnson 1998 iready  and (c)1994 Mycal labs www.mycal.net
//           
#include <windows.h>
#include <mmsystem.h>
#include <stdlib.h>	  
#include <math.h>     
#include <memory.h>
#include "readwave.h"
#include "compress.h"   
#include "filter.h"   
#include "g.726/g726.h"     



int 
Compress_g726_32(HWND hWnd, SOUND *sound, int prefilter, int postfilter)
{                                                            
unsigned long			i;     
int						cw;    
int						chunk		=0;   
unsigned long			index		=0;
BYTE _huge				*cdata		=NULL;
BYTE _huge				*tdata		=NULL;
BYTE _huge				*ucdata		=NULL;
struct g726_state 		*gs,realgs;

  	//
	// Check to make sure we have a sample to comrpess
	//
	if(sound->data_size==0)
		return 0;               
	//
	// Initialize coder
	//                          
	gs=&realgs;
	g726_init_state(gs);	

	//
	// See if we have to pre filter
	//                             
	if(1==prefilter)
	{                                 
		lowpass1_copy(sound->pfdata,sound->data,sound->data_size); 
		tdata=sound->pfdata;
	}                       
	else   
	{
		tdata=sound->data;
	}
	
	
	//
	// Compress
	//	               
	cdata=sound->cdata;		                  
	cdata[0]=0;	            
	cdata[0]=tdata[0];
	index=1;
	for(i=1;i<sound->data_size;i++)
	{                   
		cw    = g726_32_encoder(tdata[i], AUDIO_ENCODING_8BIT_LINEAR, gs); /* 1 */
		//
		// Store info in chunk
		//                    
		cdata[index]=(cdata[index]<<4) | cw & 0xf;
		chunk++;
		if(chunk>=1)
		{
			index++;   
			chunk=0;
		}	
	}       
	//
	// Now uncompress
	//	    
	sound->ucdata[0]=cdata[0];                  
	index=1;
	for(i=1;i<sound->cdata_size;i++)
	{
		cw=(cdata[i]>>(4*(i&0x1)) & 0x0f);
        cw = g726_32_decoder(cw, AUDIO_ENCODING_8BIT_LINEAR, gs); 
  
		//
		// Store ref sample (clip to max values)
		//             
		if(cw<0)
			sound->ucdata[index++]=0;
		else if(cw>255)
			sound->ucdata[index++]=(unsigned char)0xff;
		else		    
			sound->ucdata[index++]=(unsigned char)cw;   
	}
	
	//
	// See if we want the Post Filter
	//
	if(postfilter)
	{	
		//
		// We don't filter the first byte
		//
		lowpass1(&sound->ucdata[1],index-1);	
	}        
	//
	// Exit
	//
    return 1;
}
					
         
         
         


