//- Mike Johnson 1998 iready  and (c)1994 Mycal labs www.mycal.net
#ifndef READWAVE_H
#define READWAVE_H
   

typedef struct { 
    WORD  wFormatTag; 
    WORD  nChannels; 
    DWORD nSamplesPerSec; 
    DWORD nAvgBytesPerSec; 
    WORD  nBlockAlign; 
    WORD  wBitsPerSample; 
    WORD  cbSize; 
} WAVEFORMATEX; 


typedef struct SOUND_
{   
	//
	//  Wav Data 
	//  
	HANDLE          dataHandle;
	HPSTR           data;       
	DWORD           data_size;     
	DWORD			odata_size;    
	//
	// Prefiltered Data
	//                 
	HANDLE			pfdataHandle;
	HPSTR			pfdata;
	DWORD			pfdata_size;
	//
	// Compressed Data
	//
	HANDLE			cdataHandle;
	HPSTR			cdata;
	DWORD			cdata_size;
	//
	// Uncompressed Data
	//
	HANDLE			ucdataHandle;
	HPSTR			ucdata; 
	DWORD			ucdata_size; 
	//  
	// Original Format
	//
	WAVEFORMATEX	oformat; 
	//
	// New Format
	//           
	WAVEFORMATEX	format;
}SOUND;  

//
// Data Types
//
typedef struct waveInst 
{
    HANDLE hWaveInst;
    HANDLE hWaveHdr;
    HANDLE hWaveData;
} WAVEINST;

typedef WAVEINST FAR *LPWAVEINST;


int	Read_Wave(HWND, char *, SOUND *);
int	Read_AUF(HWND, char *, SOUND *);
int Play_Sound(HWND,SOUND *,int); 
void Play_Sound_Cleanup(void);
void Cleanup_Sound(SOUND *);
void Cleanup_Compressed_Sound(SOUND *);   
int SaveFileASCII(char *, HPSTR, long);
int SaveFileWav(char *, HPSTR, long); 



#endif

