//- Mike Johnson 1998 iready  and (c)1994 Mycal labs www.mycal.net
#include <windows.h>
#include <mmsystem.h>   
#include <stdio.h>     
#include "file.h"
#include "readwave.h"


HWAVEOUT    hWaveOut    = NULL;
LPWAVEHDR   lpWaveHdr   = NULL;    
HANDLE      hWaveHdr;
HANDLE      hWaveInst;                                                    

//------------------------------------------------------------------------
// init_sound - Initialize a sound structure
//------------------------------------------------------------------------
void
init_sound(sound)
SOUND	*sound;
{
    sound->dataHandle=0;                          
    sound->data=NULL;
    sound->odata_size=
    sound->data_size=0; 
	sound->pfdataHandle=0;
	sound->pfdata=NULL;
	sound->cdataHandle=0;
	sound->cdata=NULL;
	sound->cdata_size=0;
	sound->ucdataHandle=0;
	sound->ucdata=NULL;
	sound->ucdata_size=0;
}

//------------------------------------------------------------------------
// init_sound - Initialize a sound structure
//------------------------------------------------------------------------
void
free_sound_mem(sound)
SOUND	*sound;
{ 
	//
	//
	//
	if(sound->dataHandle)
	{                           
		if(sound->data)
			GlobalUnlock(sound->dataHandle);
    	GlobalFree(sound->dataHandle);		
		sound->dataHandle=0;
		sound->data=NULL;
	}
	//
	//
	//
	if(sound->pfdataHandle)
	{                           
		if(sound->pfdata)
			GlobalUnlock(sound->pfdataHandle);
    	GlobalFree(sound->dataHandle);		
		sound->pfdataHandle=0;
		sound->pfdata=NULL;
	}	
	//
	//
	//
	if(sound->cdataHandle)
	{                           
		if(sound->cdata)
			GlobalUnlock(sound->cdataHandle);
    	GlobalFree(sound->cdataHandle);		
		sound->cdataHandle=0;
		sound->cdata=NULL;
	}	
	//
	//
	//
	if(sound->ucdataHandle)
	{                           
		if(sound->ucdata)
			GlobalUnlock(sound->ucdataHandle);
    	GlobalFree(sound->ucdataHandle);		
		sound->ucdataHandle=0;
		sound->ucdata=NULL;
	}                  
	//
	// Zero Data Sizes
	//
	sound->cdata_size=0;
	sound->odata_size=0;
    sound->data_size=0; 
	sound->ucdata_size=0;
}

//------------------------------------------------------------------------
// alloc_sound_mem - Alloc Memory for a sound file.
//------------------------------------------------------------------------
int
alloc_sound_mem(sound,count)
SOUND	*sound;
long	count;
{

	if(count==0)
		return-1;         
		
	free_sound_mem(sound);		

	//-------------------------------------------------------------------------
    // Allocate and lock memory for the waveform data add 2k for padding
    //-------------------------------------------------------------------------
    sound->dataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, count+2048 );
    if (!sound->dataHandle)
        return -1;
    sound->data = GlobalLock(sound->dataHandle);
    if (!sound->data)
    {
		free_sound_mem(sound);
        return -1;
    }
    //-------------------------------------------------------------------------
    // Setup the compressed and uncompressed memory							  -
    //-------------------------------------------------------------------------
	//    
	// Alloc and lock Uncompressed space
	//    																	
	sound->ucdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, count+2048);
	if (!sound->ucdataHandle)
    {
		free_sound_mem(sound);
        return -1;
    } 																					
    sound->ucdata = GlobalLock(sound->ucdataHandle);
    if (!sound->ucdata)
    {                       						
		free_sound_mem(sound);
        return -1;
    }
	//
	// Alloc Prefiltered space
	//	 																		
	sound->pfdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, count+2048);
	if (!sound->pfdataHandle)
    {
		free_sound_mem(sound);
    	return -1;
    } 																					
    sound->pfdata = GlobalLock(sound->pfdataHandle);
    if (!sound->pfdata)
    {            
    	free_sound_mem(sound);           						
    	return -1;
    }              
    //
    // Alloc Compressed Data
    //                      											
	sound->cdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, (count/2)+2048);
	if (!sound->cdataHandle)
    {
		free_sound_mem(sound);
        return -1;
    }                					
    sound->cdata = GlobalLock(sound->cdataHandle);
    if (!sound->cdata)
    {    												                   						
		free_sound_mem(sound);
        return -1;
    }             
    
    sound->data_size=count;
    
    return 0;
}
        
        
//------------------------------------------------------------------------
// Read_Wave - Read a .wav file off the disk
//------------------------------------------------------------------------
int
Read_Wave(hwndApp,szFileName,sound)
HWND 		hwndApp;
char		*szFileName;          
SOUND		*sound;
{                                   
char			tstr[80];
HMMIO           hmmio;
MMCKINFO        mmckinfoParent;
MMCKINFO        mmckinfoSubchunk;
DWORD           dwFmtSize;
//HANDLE          hFormat;
//WAVEFORMAT      *pFormat;
DWORD           dwDataSize;
//HPSTR           hpch1, hpch2;
WORD            wBlockSize;
HANDLE          hData       	= NULL;
HPSTR           lpData      	= NULL;    
HANDLE          ucdataHandle    = NULL;
HPSTR           ucdata      	= NULL; 
HANDLE          pfdataHandle    = NULL;
HPSTR           pfdata      	= NULL;      
HANDLE          cdataHandle	    = NULL;
HPSTR           cdata      		= NULL;                                  
HPSTR			tdata			=NULL;
	//
    // Open the given file for reading using buffered I/O.
    //
    if(!(hmmio = mmioOpen(szFileName, NULL, MMIO_READ | MMIO_ALLOCBUF)))
    {
        MessageBox(hwndApp, "Failed to open file.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    }
    //
    // Locate a 'RIFF' chunk with a 'WAVE' form type 
    // to make sure it's a WAVE file.
    //
    mmckinfoParent.fccType = mmioFOURCC('W', 'A', 'V', 'E');
    if (mmioDescend(hmmio, (LPMMCKINFO) &mmckinfoParent, NULL, MMIO_FINDRIFF))
    {
        MessageBox(hwndApp, "This is not a WAVE file.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 0;
    }
    
    /* Now, find the format chunk (form type 'fmt '). It should be
     * a subchunk of the 'RIFF' parent chunk.
     */
    mmckinfoSubchunk.ckid = mmioFOURCC('f', 'm', 't', ' ');
    if (mmioDescend(hmmio, &mmckinfoSubchunk, &mmckinfoParent, 
        MMIO_FINDCHUNK))
    {
        MessageBox(hwndApp, "WAVE file is corrupted.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 0;
    }
    //
    // Get the size of the format chunk, allocate and lock memory for it.
    //
    dwFmtSize = mmckinfoSubchunk.cksize;
	if(sizeof(WAVEFORMATEX) < dwFmtSize)
    {
			sprintf(tstr,"wave alloc =%lu 	dwfmtsize = %lu\n",(DWORD)sizeof(WAVEFORMATEX),
						dwFmtSize);
	        MessageBox(hwndApp, tstr,
                   NULL, MB_OK | MB_ICONEXCLAMATION);
			return 0;
	} 
	 

    //
    // Read the format chunk.
    //
    if (mmioRead(hmmio, (HPSTR) &sound->oformat, dwFmtSize) != (LONG) dwFmtSize)
    {
        MessageBox(hwndApp, "Failed to read format chunk.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 0;
    }     
    sound->format=sound->oformat;
    //
    // Make sure it's a PCM file.
    //
    if (sound->format.wFormatTag != WAVE_FORMAT_PCM)
    {
        mmioClose(hmmio, 0);
        MessageBox(hwndApp, "The file is not a PCM file.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    } 
    //
    // Ascend out of the format subchunk.
    //
    mmioAscend(hmmio, &mmckinfoSubchunk, 0);
    //
    // Find the data subchunk.
    //
    mmckinfoSubchunk.ckid = mmioFOURCC('d', 'a', 't', 'a');
    if (mmioDescend(hmmio, &mmckinfoSubchunk, &mmckinfoParent,
        MMIO_FINDCHUNK))
    {
        MessageBox(hwndApp, "WAVE file has no data chunk.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 0;
    }
    //
    // Get the size of the data subchunk.
    //
    dwDataSize = mmckinfoSubchunk.cksize;
    if (dwDataSize == 0L)
    {
        MessageBox(hwndApp, "The data chunk has no data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 0;
    }
	//
	//
	//						
	if(alloc_sound_mem(sound,dwDataSize))
	{
        MessageBox(hwndApp, "Error Allocating Sound Memory",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 0;		
	}
    //
    // Set size.
    //
    sound->data_size=dwDataSize;
    sound->odata_size=dwDataSize;
    //
    // Save block alignment info for later use.
    //
    wBlockSize = sound->format.nBlockAlign;
    //
    // Read the waveform data subchunk.
    //
    if(mmioRead(hmmio, (HPSTR) sound->data, dwDataSize) != (LONG) dwDataSize)
    {
        MessageBox(hwndApp, "Failed to read data chunk.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 0;
    }
    //
    // We're done with the file, close it.
    //
    mmioClose(hmmio, 0);

    //-------------------------------------------------------------------------
    // Setup the compressed and uncompressed memory							  -
    //-------------------------------------------------------------------------

	return 1;
}



//------------------------------------------------------------------------
// Read_AUF - Read a .auf file off the disk
//------------------------------------------------------------------------
int
Read_AUF(hwndApp,szFileName,sound)
HWND 		hwndApp;
char		*szFileName;          
SOUND		*sound;
{            
unsigned char	value;            
int		ret;
long	count=0;
FILE	*sfile;
char	tstr[128];
                   
	ret=1;                   
	sfile=fopen(szFileName,"r");
	if(sfile)
	{           
		//
		// First calculate file size
		//      
		count=0;                    
		while(readln_from_a_file(sfile, tstr, 10))
		{
			count++;	
		}		
		//
		// Alloc and lock memory
		//
        if(alloc_sound_mem(sound,count))
        {
        	MessageBox(hwndApp, "Failed to allocate and lock memory sound.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);        	          
            fclose(sfile);
            return(0);	       
        }                        
		//
		// Read in the file and store into memory
		//                                
		rewind(sfile); 
		count=0;
		while(readln_from_a_file(sfile, tstr, 10))
		{ 
			sscanf(tstr,"%x",&value); 
			sound->data[count++]=value;
		}
		fclose(sfile);	
		//
		// Create Sound Format
		//
		sound->format.wFormatTag=WAVE_FORMAT_PCM;
		sound->format.nChannels=1;
		sound->format.nBlockAlign=1;
		sound->format.nSamplesPerSec=	
		sound->format.nAvgBytesPerSec=8000; 
		sound->format.wBitsPerSample=8;  
		sound->data_size=count;       
		sound->oformat=sound->format;


//    WORD  cbSize; 

	}
	else
	{                           
		sprintf(tstr, "Error opening file %s\n",szFileName);
        MessageBox(hwndApp, tstr,
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        ret= 0;		
	}
     
	return(ret);            
}


//------------------------------------------------------------------------
// Play a sound file (in a sound structure)
//------------------------------------------------------------------------
Play_Sound(hwndApp,sound,flag)
HWND 		hwndApp;
SOUND		*sound;
int			flag;
{              
//HANDLE          hFormat;	
//WAVEFORMAT      *pFormat;
LPWAVEINST      lpWaveInst;    	
WORD            wResult;
	//
	// Make sure we have data in the sound file.
	//
	if(flag)
	{
		if(sound->ucdata_size<1)
			return 0;
	}
	else
	{
		if(sound->data_size<1)
			return 0;
	}		  
   	//
   	// Check to see if the wave device is open already, if so close it.
   	//
   	if(hWaveOut)
   		Play_Sound_Cleanup();
    //
    // Make sure a waveform output device supports this format.
    //															
    if (waveOutOpen(&hWaveOut, (UINT)WAVE_MAPPER, (LPWAVEFORMAT)&sound->format, NULL, 0L,
            (DWORD)WAVE_FORMAT_QUERY))
    {
        MessageBox(hwndApp, "The waveform device can't play this format.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    }
    //
    // Open a waveform output device.
    //
    if (waveOutOpen((LPHWAVEOUT)&hWaveOut, (UINT)WAVE_MAPPER,
          (LPWAVEFORMAT)&sound->format, (UINT)hwndApp, 0L, (DWORD)CALLBACK_WINDOW))
    {
        MessageBox(hwndApp, "Failed to open waveform output device.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    }
    //
    // Allocate a waveform data header. The WAVEHDR must be 
    // globally allocated and locked.
    //
    hWaveHdr = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE,
                           (DWORD) sizeof(WAVEHDR));
    if (!hWaveHdr)
    {
        MessageBox(hwndApp, "Not enough memory for Wave header.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    }
    lpWaveHdr = (LPWAVEHDR) GlobalLock(hWaveHdr);
    if (!lpWaveHdr)
    {
        GlobalFree( hWaveHdr );
        MessageBox(hwndApp, "Failed to lock memory for Wave header.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    }     												
    //
    // Allocate and set up instance data for waveform data block.
    // This information is needed by the routine that frees the
    // data block after it has been played.
    //
    hWaveInst = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE,
                            (DWORD) sizeof(WAVEHDR));
    if (!hWaveInst)
    {
        GlobalUnlock( hWaveHdr );
        GlobalFree( hWaveHdr );
        MessageBox(hwndApp, "Not enough memory for Wave instance data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    }
    lpWaveInst = (LPWAVEINST) GlobalLock(hWaveInst);
    if (!lpWaveInst)
    {
        GlobalUnlock( hWaveHdr );
        GlobalFree( hWaveHdr );
        GlobalFree( hWaveInst ); 						
        MessageBox(hwndApp, "Failed to lock memory for Wave instance data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    }
    lpWaveInst->hWaveInst = hWaveInst;
    lpWaveInst->hWaveHdr = hWaveHdr;
    
    if(flag)
	{
    	lpWaveInst->hWaveData = sound->ucdataHandle;
    	lpWaveHdr->lpData = sound->ucdata;
    	lpWaveHdr->dwBufferLength = sound->ucdata_size;
    }
    else
    {                
	   	lpWaveInst->hWaveData = sound->dataHandle;
    	lpWaveHdr->lpData = sound->data;
    	lpWaveHdr->dwBufferLength = sound->data_size;
    }
    
    lpWaveHdr->dwFlags = 0L;
    lpWaveHdr->dwLoops = 0L;
    lpWaveHdr->dwUser = (DWORD) lpWaveInst;
    if(waveOutPrepareHeader(hWaveOut, lpWaveHdr, sizeof(WAVEHDR)))
    {
        GlobalUnlock( hWaveHdr );
        GlobalFree( hWaveHdr );
        GlobalUnlock( hWaveInst );
        GlobalFree( hWaveInst );
        MessageBox(hwndApp, "Unable to prepare wave header.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
               
        return 0;
    }
    //    
    // Then the data block can be sent to the output device.
    //
    wResult = waveOutWrite(hWaveOut, lpWaveHdr, sizeof(WAVEHDR));
    if (wResult != 0)
    {
        waveOutUnprepareHeader( hWaveOut, lpWaveHdr, sizeof(WAVEHDR));
        MessageBox(hwndApp, "Failed to write block to device",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
    	waveOutClose( (HWAVEOUT) hWaveOut);  
    	hWaveOut=NULL;
    	return 0;
    }
    //
    //
    //   
	return 1;
}


    
//------------------------------------------------------------------------
// Clean Up the open sound device.
//------------------------------------------------------------------------
void    
Play_Sound_Cleanup()
{
   
   	if(hWaveOut)
   	{
    	//
    	// Make sure we are not playing sound, do a reset.
    	//			
    	waveOutReset(hWaveOut);      
    	//
    	// Unprepair wave device.
    	//
    	waveOutUnprepareHeader( hWaveOut, lpWaveHdr, sizeof(WAVEHDR));    
	   	//
   		// Get a pointer to the instance data, then unlock and free
	    //	all memory associated with the data block, including the
    	// 	memory for the instance data itself.
	    //
       	GlobalUnlock( hWaveHdr );
	    GlobalFree( hWaveHdr );
	    GlobalUnlock( hWaveInst );
    	GlobalFree( hWaveInst );
	    //
    	// Close the waveform output device.
	    //
    	waveOutClose( (HWAVEOUT) hWaveOut);  
    	hWaveOut=NULL;
	}	
}

//
// Cleanup_Sound -
//
void
Cleanup_Sound(sound)
SOUND	*sound;
{
   	if(sound->dataHandle)
	{        		
    	GlobalUnlock(sound->dataHandle);
    	GlobalFree(sound->dataHandle);
    	sound->dataHandle=0;
    	sound->data_size=0;
    }	                    
/*    if(sound->formatHandle)
    {
    	GlobalUnlock(sound->formatHandle);
        GlobalFree(sound->formatHandle);
		sound->formatHandle=0;
	}
*/
   	if(sound->cdataHandle)
	{        		
    	GlobalUnlock(sound->cdataHandle);
    	GlobalFree(sound->cdataHandle);
    	sound->cdataHandle=0;
    	sound->cdata_size=0;
    }	                    
	          				
	if(sound->pfdataHandle)
	{
		GlobalUnlock(sound->pfdataHandle);
		GlobalFree(sound->pfdataHandle);
		sound->pfdataHandle=0;      
		sound->pfdata_size=0;
	}
	
	if(sound->ucdataHandle)
    {
    	GlobalUnlock(sound->ucdataHandle);
        GlobalFree(sound->ucdataHandle);
		sound->ucdataHandle=0;
		sound->ucdata_size=0;
	}
} 


int 				
SaveFileASCII(filename,data,len)
char	*filename;
HPSTR	data;            
long	len;
{   
FILE			*sfile;
unsigned char	c;
long			i; 
int				ret;      

	sfile=fopen(filename,"r");
	if(sfile)
	{        
		//
		// Close File
		//
		fclose(sfile); 
		//
		// Ask if your want to overwrite file
		//            
		ret=MessageBox(NULL,"File exists, do you wish to overwrite?","File Exists",
				MB_YESNO);
		if((0==ret) || (IDNO==ret))
			return(1);
	} 
	//
	// Open the file for writing
	//     
	sfile=fopen(filename,"w");
	if(sfile)
	{       
		for(i=0;i<len;i++)
		{     
			c=data[i];
			fprintf(sfile,"%.2x\n",c);
		}
		fclose(sfile);   
		return(0);
	}             
	return(1);
}
 
//--------------------------------------------------------------------
// SaveFileWav()  Write a wave file
//
//
//--------------------------------------------------------------------- 
int 				
SaveFileWav(filename,data,len)
char	*filename;
HPSTR	data;            
long	len;
{   
FILE			*sfile;
unsigned char	c;
long			i;  
int				j;
int				ret;    
  

	sfile=fopen(filename,"r");
	if(sfile)
	{        
		//
		// Close File
		//
		fclose(sfile); 
		//
		// Ask if your want to overwrite file
		//            
		ret=MessageBox(NULL,"File exists, do you wish to overwrite?","File Exists",
				MB_YESNO);
		if((0==ret) || (IDNO==ret))
			return(1);
	} 
	//
	// Open the file for writing
	//     
	sfile=fopen(filename,"w+b");
	if(sfile)
	{       
		//
		// Write the Wave header
		//
		//52 49 46 46 L0 L1 L2 L3 57 41 56 45 66 6d 74 20 10 00 00 00 01 00 01 00 40
		//1f 00 00 40 1f 00 00 01 00 08 00 64 61 74 64 S0 S1 S2 S3 
		//
		//
		fprintf(sfile,"RIFF");
		i=len+0x24; 
		fwrite(&i,sizeof(long),1,sfile);
		//
		// Write Wave header
		//
		fprintf(sfile,"WAVEfmt ");
		//
		// Write wave header length (0x10)
		//
		i=0x10;
		fwrite(&i,sizeof(long),1,sfile);  
		//
		// Write tag (1)
		//                             
		j=0x01;
		fwrite(&j,sizeof(int),1,sfile);
		//
		// Write Number of channels (1)
		//                             
		j=0x01;
		fwrite(&j,sizeof(int),1,sfile);
		//
		// Write sample rate (0x1f40)
		//
		i=0x1f40;
		fwrite(&i,sizeof(long),1,sfile);
		//
		// Write avg bytes sec (0x1f40)
		//
		i=0x1f40;
		fwrite(&i,sizeof(long),1,sfile);
		//
		// Block align (1)
		//                             
		j=0x01;
		fwrite(&j,sizeof(int),1,sfile);			
		//
		// Bits a sample(8)
		//                             
		j=0x08;
		fwrite(&j,sizeof(int),1,sfile);			
		//
		// Write Data
		//           
		fprintf(sfile,"data");
		//
		// Data size
		//
		fwrite(&len,sizeof(long),1,sfile);		
		//
	    // Write the wave Data
	    //  
	    //fwrite(data,sizeof(char),len,sfile);
	    
		for(i=0;i<len;i++)
		{                 
			
			c=data[i];
		    fwrite(&c,sizeof(char),1,sfile);
		}
		fclose(sfile);   
		return(0);
	}             
	return(1);
}


