//- Mike Johnson 1998 iready  and (c)1994 Mycal labs www.mycal.net
#include <windows.h>
#include <mmsystem.h>  
#include "readwave.h"


HWAVEOUT    hWaveOut    = NULL;
LPWAVEHDR   lpWaveHdr   = NULL;    
HANDLE      hWaveHdr;
HANDLE      hWaveInst;


//------------------------------------------------------------------------
// Read_Wave - Read a .wav file off the disk
//------------------------------------------------------------------------
int
Read_Wave(hwndApp,szFileName,sound)
HWND 		hwndApp;
char		*szFileName;          
SOUND		*sound;
{
HMMIO           hmmio;
MMCKINFO        mmckinfoParent;
MMCKINFO        mmckinfoSubchunk;
DWORD           dwFmtSize;
HANDLE          hFormat;
WAVEFORMAT      *pFormat;
DWORD           dwDataSize;
//HPSTR           hpch1, hpch2;
WORD            wBlockSize;
HANDLE          hData       = NULL;
HPSTR           lpData      = NULL;    
HANDLE          ucdataHandle    = NULL;
HPSTR           ucdata      	= NULL; 
HANDLE          pfdataHandle    = NULL;
HPSTR           pfdata      	= NULL;      
HANDLE          cdataHandle	    = NULL;
HPSTR           cdata      		= NULL;                                  
HPSTR			tdata			=NULL;
	//
    // Open the given file for reading using buffered I/O.
    //
    if(!(hmmio = mmioOpen(szFileName, NULL, MMIO_READ | MMIO_ALLOCBUF)))
    {
        MessageBox(hwndApp, "Failed to open file.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    }
    //
    // Locate a 'RIFF' chunk with a 'WAVE' form type 
    // to make sure it's a WAVE file.
    //
    mmckinfoParent.fccType = mmioFOURCC('W', 'A', 'V', 'E');
    if (mmioDescend(hmmio, (LPMMCKINFO) &mmckinfoParent, NULL, MMIO_FINDRIFF))
    {
        MessageBox(hwndApp, "This is not a WAVE file.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 0;
    }
    
    /* Now, find the format chunk (form type 'fmt '). It should be
     * a subchunk of the 'RIFF' parent chunk.
     */
    mmckinfoSubchunk.ckid = mmioFOURCC('f', 'm', 't', ' ');
    if (mmioDescend(hmmio, &mmckinfoSubchunk, &mmckinfoParent, 
        MMIO_FINDCHUNK))
    {
        MessageBox(hwndApp, "WAVE file is corrupted.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 0;
    }
    //
    // Get the size of the format chunk, allocate and lock memory for it.
    //
    dwFmtSize = mmckinfoSubchunk.cksize;
    hFormat = GlobalAlloc(LMEM_MOVEABLE, LOWORD(dwFmtSize));
    if (!hFormat)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 0;
    }
    pFormat = (WAVEFORMAT *) GlobalLock(hFormat);
    if (!pFormat)
    {
        MessageBox(hwndApp, "Failed to lock memory for format chunk.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree( hFormat );
        mmioClose(hmmio, 0);
        return 0;
    }
    //
    // Read the format chunk.
    //
    if (mmioRead(hmmio, (HPSTR) pFormat, dwFmtSize) != (LONG) dwFmtSize)
    {
        MessageBox(hwndApp, "Failed to read format chunk.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalUnlock( hFormat );
        GlobalFree( hFormat );
        mmioClose(hmmio, 0);
        return 0;
    }
    //
    // Make sure it's a PCM file.
    //
    if (pFormat->wFormatTag != WAVE_FORMAT_PCM)
    {
        GlobalUnlock( hFormat );
        GlobalFree( hFormat );
        mmioClose(hmmio, 0);
        MessageBox(hwndApp, "The file is not a PCM file.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    } 
    //
    // Ascend out of the format subchunk.
    //
    mmioAscend(hmmio, &mmckinfoSubchunk, 0);
    //
    // Find the data subchunk.
    //
    mmckinfoSubchunk.ckid = mmioFOURCC('d', 'a', 't', 'a');
    if (mmioDescend(hmmio, &mmckinfoSubchunk, &mmckinfoParent,
        MMIO_FINDCHUNK))
    {
        MessageBox(hwndApp, "WAVE file has no data chunk.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalUnlock( hFormat );
        GlobalFree( hFormat );
        mmioClose(hmmio, 0);
        return 0;
    }
    //
    // Get the size of the data subchunk.
    //
    dwDataSize = mmckinfoSubchunk.cksize;
    if (dwDataSize == 0L)
    {
        MessageBox(hwndApp, "The data chunk has no data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalUnlock( hFormat );
        GlobalFree( hFormat );
        mmioClose(hmmio, 0);
        return 0;
    }
    //
    // Save block alignment info for later use.
    //
    wBlockSize = pFormat->nBlockAlign;
    //
    // We're done with the format header, free it.
    //
    //LocalUnlock( hFormat );
    //LocalFree( hFormat );
    //
    // Allocate and lock memory for the waveform data.
    //
    hData = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, dwDataSize+2048 );
    if (!hData)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        mmioClose(hmmio, 0);
        return 0;
    }
    lpData = GlobalLock(hData);
    if (!lpData)
    {
        MessageBox(hwndApp, "Failed to lock memory for data chunk.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree( hData );
    	GlobalUnlock( hFormat );
    	GlobalFree( hFormat );
        mmioClose(hmmio, 0);
        return 0;
    }
    //
    // Read the waveform data subchunk.
    //
    if(mmioRead(hmmio, (HPSTR) lpData, dwDataSize) != (LONG) dwDataSize)
    {
        MessageBox(hwndApp, "Failed to read data chunk.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalUnlock( hData );
        GlobalFree( hData );
    	GlobalUnlock( hFormat );
    	GlobalFree( hFormat );
        mmioClose(hmmio, 0);
        return 0;
    }
    //
    // We're done with the file, close it.
    //
    mmioClose(hmmio, 0);

    //-------------------------------------------------------------------------
    // Setup the compressed and uncompressed memory							  -
    //-------------------------------------------------------------------------
	if(dwDataSize==0)
		return 0;     
	//    
	// Alloc Uncompressed space
	//
	ucdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, dwDataSize+1048);
	if (!ucdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    } 																					
    ucdata = GlobalLock(ucdataHandle);
    if (!ucdata)
    {                       						
        MessageBox(hwndApp, "Failed to lock memory for Uncompressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(ucdataHandle);
        return 0;
    }
	//
	// Alloc Prefiltered space
	//	
	pfdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, dwDataSize+1048);
	if (!ucdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
    	return 0;
    } 																					
    pfdata = GlobalLock(ucdataHandle);
    if (!pfdata)
    {                       						
        MessageBox(hwndApp, "Failed to lock memory for prefiltered uncompressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
		GlobalFree(pfdataHandle);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
    	return 0;
    }              
    //
    //
    //
	cdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, dwDataSize/2);
	if (!cdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
		GlobalUnlock(pfdataHandle);
    	GlobalFree(pfdataHandle);
    	GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }                					
    cdata = GlobalLock(cdataHandle);
    if (!cdata)
    {    												                   						
        MessageBox(hwndApp, "Failed to lock memory for Compressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(cdataHandle); 
		GlobalUnlock(pfdataHandle);
    	GlobalFree(pfataHandle);        
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }
    
    //---------------------------------
    // Setup the sound structure      -
    //---------------------------------
    sound->dataHandle=hData;                          
    sound->data=lpData;
    sound->data_size=dwDataSize; 
    
    sound->formatHandle=hFormat;  
    sound->format=(WAVEFORMATEX *)pFormat;

	sound->pfdataHandle=pfdataHandle;
	sound->pfdata=pfdata;
	
	sound->cdataHandle=cdataHandle;
	sound->cdata=cdata;
	sound->cdata_size=0;

	sound->ucdataHandle=ucdataHandle;
	sound->ucdata=ucdata;
	sound->ucdata_size=0;

	return 1;
}






//------------------------------------------------------------------------
// Play a sound file (in a sound structure)
//------------------------------------------------------------------------
Play_Sound(hwndApp,sound,flag)
HWND 		hwndApp;
SOUND		*sound;
int			flag;
{              
//HANDLE          hFormat;	
//WAVEFORMAT      *pFormat;
LPWAVEINST      lpWaveInst;    	
WORD            wResult;
	//
	// Make sure we have data in the sound file.
	//
	if(flag)
	{
		if(sound->ucdata_size<1)
			return 0;
	}
	else
	{
		if(sound->data_size<1)
			return 0;
	}		  
   	//
   	// Check to see if the wave device is open already, if so close it.
   	//
   	if(hWaveOut)
   		Play_Sound_Cleanup();
    //
    // Make sure a waveform output device supports this format.
    //															
    if (waveOutOpen(&hWaveOut, (UINT)WAVE_MAPPER, (LPWAVEFORMAT)sound->format, NULL, 0L,
            (DWORD)WAVE_FORMAT_QUERY))
    {
        MessageBox(hwndApp, "The waveform device can't play this format.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    }
    //
    // Open a waveform output device.
    //
    if (waveOutOpen((LPHWAVEOUT)&hWaveOut, (UINT)WAVE_MAPPER,
          (LPWAVEFORMAT)sound->format, (UINT)hwndApp, 0L, (DWORD)CALLBACK_WINDOW))
    {
        MessageBox(hwndApp, "Failed to open waveform output device.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    }
    //
    // Allocate a waveform data header. The WAVEHDR must be 
    // globally allocated and locked.
    //
    hWaveHdr = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE,
                           (DWORD) sizeof(WAVEHDR));
    if (!hWaveHdr)
    {
        MessageBox(hwndApp, "Not enough memory for Wave header.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    }
    lpWaveHdr = (LPWAVEHDR) GlobalLock(hWaveHdr);
    if (!lpWaveHdr)
    {
        GlobalFree( hWaveHdr );
        MessageBox(hwndApp, "Failed to lock memory for Wave header.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    }     												
    //
    // Allocate and set up instance data for waveform data block.
    // This information is needed by the routine that frees the
    // data block after it has been played.
    //
    hWaveInst = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE,
                            (DWORD) sizeof(WAVEHDR));
    if (!hWaveInst)
    {
        GlobalUnlock( hWaveHdr );
        GlobalFree( hWaveHdr );
        MessageBox(hwndApp, "Not enough memory for Wave instance data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    }
    lpWaveInst = (LPWAVEINST) GlobalLock(hWaveInst);
    if (!lpWaveInst)
    {
        GlobalUnlock( hWaveHdr );
        GlobalFree( hWaveHdr );
        GlobalFree( hWaveInst ); 						
        MessageBox(hwndApp, "Failed to lock memory for Wave instance data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    }
    lpWaveInst->hWaveInst = hWaveInst;
    lpWaveInst->hWaveHdr = hWaveHdr;
    
    if(flag)
	{
    	lpWaveInst->hWaveData = sound->ucdataHandle;
    	lpWaveHdr->lpData = sound->ucdata;
    	lpWaveHdr->dwBufferLength = sound->ucdata_size;
    }
    else
    {                
	   	lpWaveInst->hWaveData = sound->dataHandle;
    	lpWaveHdr->lpData = sound->data;
    	lpWaveHdr->dwBufferLength = sound->data_size;
    }
    
    lpWaveHdr->dwFlags = 0L;
    lpWaveHdr->dwLoops = 0L;
    lpWaveHdr->dwUser = (DWORD) lpWaveInst;
    if(waveOutPrepareHeader(hWaveOut, lpWaveHdr, sizeof(WAVEHDR)))
    {
        GlobalUnlock( hWaveHdr );
        GlobalFree( hWaveHdr );
        GlobalUnlock( hWaveInst );
        GlobalFree( hWaveInst );
        MessageBox(hwndApp, "Unable to prepare wave header.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
               
        return 0;
    }
    //    
    // Then the data block can be sent to the output device.
    //
    wResult = waveOutWrite(hWaveOut, lpWaveHdr, sizeof(WAVEHDR));
    if (wResult != 0)
    {
        waveOutUnprepareHeader( hWaveOut, lpWaveHdr, sizeof(WAVEHDR));
        MessageBox(hwndApp, "Failed to write block to device",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
    	waveOutClose( (HWAVEOUT) hWaveOut);  
    	hWaveOut=NULL;
    	return 0;
    }
    //
    //
    //   
	return 1;
}


    
//------------------------------------------------------------------------
// Clean Up the open sound device.
//------------------------------------------------------------------------
void    
Play_Sound_Cleanup()
{
   
   	if(hWaveOut)
   	{
    	//
    	// Make sure we are not playing sound, do a reset.
    	//			
    	waveOutReset(hWaveOut);      
    	//
    	// Unprepair wave device.
    	//
    	waveOutUnprepareHeader( hWaveOut, lpWaveHdr, sizeof(WAVEHDR));    
	   	//
   		// Get a pointer to the instance data, then unlock and free
	    //	all memory associated with the data block, including the
    	// 	memory for the instance data itself.
	    //
       	GlobalUnlock( hWaveHdr );
	    GlobalFree( hWaveHdr );
	    GlobalUnlock( hWaveInst );
    	GlobalFree( hWaveInst );
	    //
    	// Close the waveform output device.
	    //
    	waveOutClose( (HWAVEOUT) hWaveOut);  
    	hWaveOut=NULL;
	}	
}

//
// Cleanup_Sound -
//
void
Cleanup_Sound(sound)
SOUND	*sound;
{
   	if(sound->dataHandle)
	{        		
    	GlobalUnlock(sound->dataHandle);
    	GlobalFree(sound->dataHandle);
    	sound->dataHandle=0;
    	sound->data_size=0;
    }	                    
    if(sound->formatHandle)
    {
    	GlobalUnlock(sound->formatHandle);
        GlobalFree(sound->formatHandle);
		sound->formatHandle=0;
	}
   	if(sound->cdataHandle)
	{        		
    	GlobalUnlock(sound->cdataHandle);
    	GlobalFree(sound->cdataHandle);
    	sound->cdataHandle=0;
    	sound->cdata_size=0;
    }	                    
    if(sound->ucdataHandle)
    {
    	GlobalUnlock(sound->ucdataHandle);
        GlobalFree(sound->ucdataHandle);
		sound->ucdataHandle=0;
		sound->ucdata_size=0;
	}
} 


//
// Only cleanup the compressed portion of a sound file
//
void
Cleanup_Compressed_Sound(sound)
SOUND	*sound;
{
   	if(sound->cdataHandle)
	{        		
    	GlobalUnlock(sound->cdataHandle);
    	GlobalFree(sound->cdataHandle);
    	sound->dataHandle=0;
    	sound->cdata_size=0;
    }	                    
    if(sound->ucdataHandle)
    {
    	GlobalUnlock(sound->ucdataHandle);
        GlobalFree(sound->ucdataHandle);
		sound->ucdataHandle=0;
		sound->ucdata_size=0;
	}

}

