//
//  file.c - Mike Johnson 1998 iready  and (c)1994 Mycal labs www.mycal.net
//                      
#include <windows.h>
#include "file.h"


int
readln_from_a_file(fp, line, size)
FILE    *fp;
char    *line;
int     size;
{
        char *p;

        do          
                p = fgets( line, size, fp );
        while( ( p != NULL ) && ( *line == '#') );
                      
        if( p == NULL )
                return( 0 );
        
        if (strchr(line, '\n'))
          *strchr(line, '\n') = '\0';
        if (strchr(line, '\r'))
          *strchr(line, '\r') = '\0';
        return( 1 );
}

//   
// extract_one(outdata,inptr,outsize)  - extract one field, 
//      comma delimited (CVS format).  Updates inptr.
//
char 
*extract_one(outdata,inptr,outsize)
char    *outdata;   
char    *inptr;
int     outsize;    
{
int count;
int quote=0;
    //
    // Make sure we are not at the end of the string.
    //
    if(*inptr==0)   
    {
        outdata[0]=0;  
        return(inptr);
    }
    //
    // Do extraction
    //
    if(*inptr=='"')
    {
        inptr++;
        quote=1;
    }
                 
    count=0;
    while(*inptr!=0)
    {
        if(*inptr=='"')
        {
                if(quote==1)
                {
                        inptr++;
                       if(*inptr==',')
                        {
                                quote=0;
                                continue;
                        }
                        inptr--;
                }
                inptr++;
                if(*inptr=='"')
                {
                        if(count<outsize)
                                outdata[count++]=*inptr;
                        inptr++;
                        continue;
                }
                else
                {
                        //printf("Record is trashed --> %s\n",inptr);
                }
        }
        //
        // See if we can bail
        //
        if((*inptr==',') && (quote==0))
                break;
        //
        // Store the next character
        //
        if(count<outsize)
            outdata[count++]=*inptr;
        inptr++; 
    }
    outdata[count]=0;
    //   
    //
    //
    if(*inptr==',')
        inptr++;
                
    return(inptr);
}
 
 
 
 
//
//
// 
extern char aCurrentDir[];
extern	char aa[];
int  							
read_adpcm_41_config(filename,num, step_size,step_index)
char			*filename;
int				*num;
unsigned char	*step_size;
unsigned char	*step_index;
{
FILE	*file;
char	line[1024];
char	fn[128];      
int		i;  
int		ret;
    
	strcpy(fn,&aCurrentDir[0]);
	strcat(fn,"\134");
	strcat(fn,filename);
	file=fopen(fn,"r");
	if(file==NULL)
	{        
		//
		// Tell user that file doesn't exist
		//            
		ret=MessageBox(NULL,"Step Table File adpcm41.cfg is missing",fn,
				MB_OK);
		return(-1);
	}           
	//
	// Try to read file the number of rows
	//
	ret=readln_from_a_file(file,line,1024);
	if(ret)
	{
		sscanf(line,"%x",num);  
		if((*num<1) && (*num >30))
			ret=1;
		else
		{
			for(i=0;i<*num;i++)
			{
				//
				ret=readln_from_a_file(file,line,1024);
				if(!ret)
					break;
				//
				sscanf(line,"%x",&step_size[i]);
			}
			//
			if(ret)
			{
				for(i=0;i<(*num*2);i++)
				{
					//
					ret=readln_from_a_file(file,line,1024);
					if(!ret)
						break;
					//
					sscanf(line,"%x",&step_index[i]);
					//
				}
			}		
		}
	}            
	//
	// close file
	//
	fclose(file);
	//
	// Check retcode
	//                                 
	if(!ret)
	{           
		ret=MessageBox(NULL,"Step Table File adpcm41.cfg is corrupt","File Corrupt",
				MB_OK);
		return(-1);
	}
	else
		return(0);

} 
 

int  							
read_adpcm_21_config(filename,num, step_size,step_index,step_table)
char			*filename;
int				*num;
unsigned char	*step_size;
unsigned char	*step_index;                    
unsigned char	*step_table;
{
FILE	*file;
char	line[1024];
char	fn[128];      
int		i;  
int		ret;
    
	strcpy(fn,&aCurrentDir[0]);
	strcat(fn,"\134");
	strcat(fn,filename);
	file=fopen(fn,"r");
	if(file==NULL)
	{        
		//
		// Tell user that file doesn't exist
		//            
		ret=MessageBox(NULL,"Step Table File adpcm21.cfg is missing",fn,
				MB_OK);
		return(-1);
	}           
	//
	// Try to read file the number of rows
	//
	ret=readln_from_a_file(file,line,1024);
	if(ret)
	{
		sscanf(line,"%x",num);  
		if((*num<1) && (*num >30))
			ret=1;
		else
		{     
			//
			// read step size
			//
			for(i=0;i<*num;i++)
			{
				//
				ret=readln_from_a_file(file,line,1024);
				if(!ret)
					break;
				//
				sscanf(line,"%x",&step_size[i]);
			}
			//               
			// read step index
			//
			if(ret)
			{
				for(i=0;i<(*num*8);i++)
				{
					//
					ret=readln_from_a_file(file,line,1024);
					if(!ret)
						break;
					//
					sscanf(line,"%x",&step_index[i]);
					//
				}
			}
			//
			// read step table
			//
			if(ret)
			{
				for(i=0;i<(*num*8);i++)
				{
					//
					ret=readln_from_a_file(file,line,1024);
					if(!ret)
						break;
					//
					sscanf(line,"%x",&step_table[i]);
					//
				}
			}
		
		}
	}            
	//
	// close file
	//
	fclose(file);
	//
	// Check retcode
	//                                 
	if(!ret)
	{           
		ret=MessageBox(NULL,"Step Table File adpcm21.cfg is corrupt","File Corrupt",
				MB_OK);
		return(-1);
	}
	else
		return(0);

} 
 



 
 
 
 
 