//
// Compress.c - Mike Johnson 1998 iready  and (c)1994 Mycal labs www.mycal.net
//           
#include <windows.h>
#include <mmsystem.h>
#include <stdlib.h>	  
#include <math.h>     
#include <memory.h>
#include "readwave.h"
#include "compress.h"   
#include "filter.h"

#define FILE_TABLE 1

//
// step size and index for 4:1 ADPCM compression
//        			
                               

#ifdef FILE_TABLE                               
int					step_count41=0;
unsigned char		step_size41[21];
unsigned char		step_index41[21][2];
#else                 
int			step_count41=6;
int			step_size41[] 	= {0x01,0x02,0x04,0x08,0x10,0x20};
int			step_index41[6][2]	=  {0x00,0x01,
								0x01,0x03,
								0x02,0x06,
								0x04,0x0c,
								0x08,0x18,
								0x10,0x30};   
#endif								

#ifdef FILE_TABLE                               
int					step_count21=0;
unsigned char		step_size21[21];
unsigned char		step_index21[21][8];  
unsigned char		step_table21[21][8];
#else
//
// step size and index for 2:1 ADPCM compression
//								
int		step_count21=4;
int		step_size21[]		= {	0x04, 0x08, 0x10, 0x20};
int		step_index21[4][8]	= {	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
								0x01, 0x03, 0x05, 0x07, 0x09, 0x0b, 0x0d, 0x0f,
								0x02, 0x06, 0x0a, 0x0e, 0x12, 0x16, 0x1a, 0x1e,
								0x04, 0x0c, 0x14, 0x1c, 0x24, 0x2c, 0x34, 0x3c};

int		step_table21[4][8]	= { 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08,
								0xf8, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08,								
								0xf8, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08,
								0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
#endif																																														


#define		div4(x)		((x>>2) + ((x>>1)&0x1))
#define     div2(x)     (x>>1) + (x & 0x1))

//-----------------------------------------------------------------------------
// adpcm 4:1 6 row - This is standard Soundblaster ADPCM
//----------------------------------------------------------------------------- 
int
Compress_ADPCM41_6row(hwndApp,sound,pre,post)
HWND	hwndApp;
SOUND	*sound;
int		pre;
int		post;
{                        
unsigned long			i,j;
int				delta=0;    
unsigned int	value,prev,prev1;
int				cp=0;
int				ref_sample=0;
int				row_index=0;
int				step_delta=0;	
int				chunk=0;   
int				sign=0;
unsigned long	index=0;				                 

BYTE _huge		*cdata			=NULL;
BYTE _huge		*tdata			=NULL;
BYTE _huge		*ucdata			=NULL;
	//
	// Check to make sure we have a sample to comrpess
	//
	if(sound->data_size==0)
		return 0;               
	//
	//
	//
	if(0==step_count41)
	{
		
		if(read_adpcm_41_config("adpcm41.cfg",&step_count41,
					&step_size41[0],&step_index41[0][0]))
			return 0;
	}			
	//
	// See if we have to pre filter
	//                             
	if(1==pre)
	{                                 
		lowpass1_copy(sound->pfdata,sound->data,sound->data_size); 
		tdata=sound->pfdata;
	}                       
	else   
	{
		tdata=sound->data;
	}		
	//
	// We've got memory, so compress
	//	
	cdata=sound->cdata;		                  
	cdata[0]=0;	            
	//prev=ref_sample=0x80;
	cdata[0]=prev=ref_sample=tdata[0];
	index=1;
	for(i=1;i<sound->data_size;i++)
	{                          					
		//
		//
       	value=tdata[i];
																					    				
		delta=(unsigned char)value-ref_sample;   
		
        if(delta>=0)
        	sign=0;
        else
        	sign=1;	
        //
        //
        //
		step_delta=step_size41[row_index] - abs(delta);
		if(step_delta>0)
			cp=0;
		else
			cp=1;	
		//
		//
		if(sign)
			ref_sample-=step_index41[row_index][cp];
		else
			ref_sample+=step_index41[row_index][cp];
		//
		// Adjust Row Index
		//
		if(cp)
			row_index++;
		else
			row_index--;
		//
		// Clip Row Index
		//	
		if(row_index<0)
			row_index=0;
		if(row_index>(step_count41-1))
			row_index=(step_count41-1);
		//
		// Store info in chunk
		//                    
		sound->cdata[index]=(cdata[index]<<2) | (sign<<1) | cp;
		chunk++;
		if(chunk>=4)
		{
			index++;   
			chunk=0;
		}				
		//
		// Check Direction
		//				
	}
	sound->cdata_size=index;

	//
	// Now uncompress
	//	    
	delta=0;
	step_delta=0;                  
	row_index=0;
	sound->ucdata[0]=prev=prev1=ref_sample=cdata[0];                  
	index=1;
	for(i=1;i<sound->cdata_size;i++)
	{
		//
		// Process the compressed data chunks in the byte
		//
		for(j=4;j>0;j--)
		{       
			chunk = (cdata[i] >> (2*(j-1))) & 0x03;
			cp=chunk & 0x01;
			if(chunk &0x2)
				ref_sample = ref_sample	- step_index41[row_index][cp];
			else
				ref_sample = ref_sample	+ step_index41[row_index][cp];
			//
			// Adjust Row Index
			//
			if(cp)
				row_index++;
			else
				row_index--;
			//
			// Clip Row Index
			//	
			if(row_index<0)
				row_index=0;
			if(row_index>(step_count41-1))
				row_index=step_count41-1;
			//
			// Store ref sample (clip to max values)
			//             
			if(ref_sample<0)
				sound->ucdata[index++]=0;
			else if(ref_sample>255)
				sound->ucdata[index++]=(unsigned char)0xff;
			else		    
				sound->ucdata[index++]=ref_sample;   

		}        						
	}                           
	//
	// See if we want the Post Filter
	//
	if(post)
	{	
		//
		// We don't filter the first byte
		//
		lowpass1(&sound->ucdata[1],index-1);	
	}
	
	if(index>sound->data_size)
	    sound->ucdata_size=sound->data_size;
	else
		sound->ucdata_size=index;      
	
	return 1;
} 

//------------------------------------------------------------------------
//------------------------------------------------------------------------
//
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// adpcm 2:1 - This is standard Soundblaster ADPCM
//----------------------------------------------------------------------------- 
int
Compress_ADPCM21(hwndApp,sound,pre,post)
HWND	hwndApp;
SOUND	*sound;
int		pre;
int		post;
{                        
unsigned long	i;
int				j;
int				delta=0;    
unsigned int	value,prev,prev1;
int				cp=0;
int				ref_sample=0;
int				row_index=0;
int				step_delta=0;	
int				chunk=0;   
int				sign=0;
unsigned long	index=0;				                 

BYTE _huge		*cdata			=NULL;
BYTE _huge		*tdata			=NULL;
BYTE _huge		*ucdata			=NULL;
	//
	// Check to make sure we have a sample to comrpess
	//
	if(sound->data_size==0)
		return 0;     
	//
	//
	//
	if(0==step_count21)
	{
		
		if(read_adpcm_21_config("adpcm21.cfg",&step_count21,
					&step_size21[0],&step_index21[0][0],
						&step_table21[0][0]))
			return 0;
	}	//
	// See if we have to pre filter
	//                             
	if(1==pre)
	{                                 
		lowpass1_copy(sound->pfdata,sound->data,sound->data_size); 
		tdata=sound->pfdata;
	}                       
	else   
	{
		tdata=sound->data;
	}		
	//
	// We've got memory, so compress
	//	
	cdata=sound->cdata;		                  
	cdata[0]=0;	            
	cdata[0]=prev=ref_sample=tdata[0];
	index=1;
	row_index=0;
	for(i=1;i<sound->data_size;i++)
	{                          					
		//
		// Get the data value  
		//
       	value=tdata[i];
																					    				
		delta=(unsigned char)value-ref_sample;   
		
		cp=0;       
        if(delta>=0)
        	sign=0;
        else
        	sign=0x08;	                 
		//      
	  	delta=abs(delta);		 
		if(delta >= step_size21[row_index])
		{
			cp|=0x4;
			delta-=step_size21[row_index];
		}                            
		//
		if(delta >= (step_size21[row_index]>>1))
		{
			cp|=0x2;
			delta-=(step_size21[row_index]>>1);
		}	 
		//
        if(delta >= (step_size21[row_index]>>2))
    	{       
    		cp|=0x1;
    	}
	    //
        // calc new ref sample.
		//
		if(sign)
			ref_sample-=step_index21[row_index][cp];
		else
			ref_sample+=step_index21[row_index][cp];
		//
		// Adjust Row Index
		//
		if(step_table21[row_index][cp]==0x08)
			row_index++;
		else if(step_table21[row_index][cp]==0xf8)
			row_index--;
		//
		// Clip Row Index
		//	
		if(row_index<0)
			row_index=0;
		if(row_index>(step_count21-1))
			row_index=step_count21-1;
		//
		// Store info in chunk
		//                    
		cdata[index]=(cdata[index]<<4) | cp | sign;
		chunk++;
		if(chunk>=2)
		{
			index++;   
			chunk=0;
		}				
	}
	sound->cdata_size=index;

	//-------------------------
	// Now uncompress         -
	//-------------------------	    
	delta=0;
	step_delta=0;                  
	row_index=0;
	sound->ucdata[0]=prev=prev1=ref_sample=cdata[0];                  
	index=1;
	for(i=1;i<sound->cdata_size;i++)
	{
		//
		// Process the compressed data chunks in the byte
		//
		for(j=1;j>=0;j--)
		{       
			chunk = (cdata[i] >> (4*(j))) & 0x0f;
		
			sign=chunk & 0x08;
			cp=chunk & 0x07;
			
			if(sign)               					
				ref_sample = ref_sample	- step_index21[row_index][cp];
			else
				ref_sample = ref_sample	+ step_index21[row_index][cp];
			//
			// Adjust Row Index
			//
			if(step_table21[row_index][cp]==0x08)
				row_index++;
			else if(step_table21[row_index][cp]==0xf8)
				row_index--;
			//
			// Clip Row Index
			//	
			if(row_index<0)
				row_index=0;
			if(row_index>(step_count21-1))
				row_index=step_count21-1;
			//
			// Store ref sample (clip to max values)
			//             
			if(ref_sample<0)
				sound->ucdata[index++]=0;
			else if(ref_sample>255)
				sound->ucdata[index++]=(unsigned char)0xff;
			else		    
				sound->ucdata[index++]=ref_sample;   

		}        						
	}                           
	//
	// See if we want the Post Filter
	//
	if(post)
	{	
		//
		// We don't filter the first byte
		//
		lowpass1(&sound->ucdata[1],index-1);	
	}
	
	if(index>sound->data_size)
	    sound->ucdata_size=sound->data_size;
	else
		sound->ucdata_size=index;      
	
	return 1;
} 


//------------------------------------------------------------------------
//------------------------------------------------------------------------
//
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
int
Compress_ABC(hwndApp,sound,pre,post,block,lpc)
HWND	hwndApp;
SOUND	*sound;
int		pre;
int		post;                               
int		block;
int		lpc;
{ 
int				step_size,cross;
unsigned		block_size;
unsigned char	step;
static	int		tt;
int				t,value,last,overload;                       
unsigned long	i,j;
int				prev,prev1,preva;
int				ref_sample=0;
long			counter=0;
long			index=0;				                 
                                  
HPSTR			tdata			=NULL;
	//
	// Cleanup any perviously created compressed samples
	//
	if(sound->data_size==0)
		return 0;
	//
	// We've got memory, so compress
	//	
	//
	// See if we have to pre filter
	//                             
	if(1==pre)
	{                                 
		lowpass1_copy(sound->pfdata,sound->data,sound->data_size); 
		tdata=sound->pfdata;
	}                       
	else   
	{
		tdata=sound->data;
	}		
	    
	if(block) 
        block_size=block;
	else
		block_size=128;
		
	ref_sample=0;
	index=0;  
	j=0;                             
	last=0;
	overload=0;             
	prev=0x0;       
	preva=0;
	while(j<sound->data_size)
	{ 
		//
		// Find the average slope
		//     
		step_size=0;
		cross=0;                                    
		for(i=0;i<block_size;i++)
		{
			
			if((i+j) > sound->data_size)
			{
				step_size=step_size + (abs(0x0 - prev));
				prev=0x80;
			}
			else		
			{									
    	    	value=(unsigned char)tdata[j+i];

				t=(value-128);   
				step_size=step_size +abs(t - prev);
				prev=t;
			}	
		} 								            
		step_size=step_size/(block_size);

		step=step_size & 0x7f;
		//
		// Store step size
		//	             
		sound->cdata[index++]=step; 
		//
		// Compute block if step_size
		//                           
		if(step)                                
		{
			counter=0;
			for(i=0;i<block_size;i++)
			{       
				if(lpc) 											
					//ref_sample = (ref_sample>>2) + (ref_sample>>1) +
					//	(ref_sample & 1);
                    ref_sample=ref_sample *.89;  
                      
				if((i+j) > sound->data_size)
					t=(unsigned char)0;
				else
					t=(int)((unsigned char)tdata[i+j])-128;
										                        
				if(t > (ref_sample))
			    {               
			    	if(last==0)
			    		overload=0;
			    	ref_sample=ref_sample+step;//	(step+(overload*(step>>2)));
			    	sound->cdata[index+(counter>>3)] = sound->cdata[index+(counter>>3)] 
			    								| 1 << (counter %8); 
			    	overload++;
			    	last=1;							
			    }  
			    else
			    {          
			    	if(last==1)
			    		overload=0;                         
			    	if(cross)
			    		overload=0;
			    	ref_sample=ref_sample-step;//(step+(overload*(step>>2)));   
			    	sound->cdata[index+(counter>>3)] = sound->cdata[index+(counter>>3)]
			    								& ~(1 << (counter % 8));
					overload++;
			    	last=0;
			    }
				counter++;
			}             
			index=index+block_size/8;
		}   
		//else
		//	ref_sample=0;
			               
		j=j+block_size;
	}//end while	
	//
	// Store compressed data size
	//  					
	sound->cdata_size=index;

	//
	// Decompress
	//	
	ref_sample=0x0;
	index=0;
	j=0;                       
	last=0;
	overload=0;   
	prev=0;
	while(j<sound->cdata_size)
	{
		if(sound->cdata[j]==0)
		{                                  
			//
			// Replicate Silence at current ref_sample
			//                                        
			//ref_sample=0;
			for(i=0;i<block_size;i++)
			{

				sound->ucdata[index++]=ref_sample+128;//ref_sample;		
							
				if(post)
				{          
					if(index>1)
					{        
						prev1=sound->ucdata[index-2]; 										
						sound->ucdata[index-2]=(((unsigned char)prev)/4 + ((unsigned char)sound->ucdata[index-2])/2
							 +((unsigned char)sound->ucdata[index-1])/4);  
						prev=prev1;	 
					}
				}
			}
			//ref_sample=0;
			j++;
		}		                           
		else
		{              
			step=sound->cdata[j++];
			for(i=1;i<block_size+1;i++)
			{                  

				if(lpc)                        
					ref_sample=ref_sample * .89;
					//ref_sample =  (ref_sample>>2) + (ref_sample>>1) +
					//	(ref_sample & 1);
																                 								
				if(sound->cdata[j+((i-1)>>3)] & (1 << ((i-1) % 8)))
				{
					if(last==0)
						overload=0;
					ref_sample=ref_sample + step;//(step+(overload*(step>>2)));
					overload++;
					last=1;
				}                                     
				else
				{                  
					if(last==1)
						overload=0;
					ref_sample=ref_sample - step;//(step+(overload*(step>>2)));				
					overload++;
					last=0;
				} 
				//
				// clip
				//
				t=(ref_sample)+128;
        		if(t>255)
        			t=255;
        		if(t<0)
        			t=0;	
        		sound->ucdata[index++]=(unsigned char)t;
			}
			j=j+(block_size/8);
		}
	}
	sound->ucdata_size=index;      
	//
	// See if we want to post filter.
	//                               
	if(post)
	{ 
		lowpass1(sound->ucdata,index);     
	}
	
	return 1;
}

//------------------------------------------------------------------------
//------------------------------------------------------------------------
//
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
int
Compress_ABC3(hwndApp,sound,pre,post,block,lpc)
HWND	hwndApp;
SOUND	*sound;
int		pre;
int		post;                               
int		block;
int		lpc;
{ 
int				step_size,cross,oldsign;
unsigned		block_size;
unsigned char	step;
static	int		tt;
int				t,value,last,overload;                       
unsigned long	i,j;
int				prev,prev1,preva;
int				ref_sample=0;
long			counter=0;
long			index=0;				                 
                                
HPSTR			tdata			=NULL;    
HPSTR			wdata			=NULL;
	//
	// See if we have anything to compress
	//													
	if(sound->data_size==0)
		return 0;
	//
	// See if we have to pre filter
	//                             
	if(1==pre)
	{                                 
		lowpass1_copy(sound->pfdata,sound->data,sound->data_size); 
		tdata=sound->pfdata;
	}                       
	else   
	{
		tdata=sound->data;
	}
	//
	// We've got memory, so compress
	//	

	if(block) 
        block_size=block;
	else
		block_size=128;
		
	ref_sample=0;
	index=0;  
	j=0;                             
	last=0;
	overload=0;             
	prev=0x0;       
	preva=0;
	while(j<sound->data_size)
	{ 
		//
		// Find the average slope
		//     
		step_size=0;
		cross=0;                                    
		prev=(((unsigned char)tdata[j])-128)<<2;
		for(i=1;i<block_size;i++)
		{
			
			if((i+j) > sound->data_size)
			{
				step_size=step_size + (abs(0x0 - prev));
				prev=0x0;
			}
			else		
			{									
 		       	value=(unsigned char)tdata[j+i];
                t=(value-128)<<2;
				step_size=step_size +abs(t - prev);
				prev=t;
			}	
		} 								            
		step_size=step_size/(block_size/2);
		step=step_size;      
		
		if(step<1)
			step=0;
		//
		// Store step size
		//	   
		sound->cdata[index++]=step;
		//
		// Compute block if step_size
		//                           
		if(step)                                
		{
			counter=0;
			for(i=0;i<block_size;i++)
			{       
				if(lpc)   
				{
					ref_sample = (ref_sample>>2) + (ref_sample>>1) + 
						(ref_sample & 1);
                }
                
				if((i+j) > sound->data_size)
					t=(unsigned char)0;
				else
					t=(int)((unsigned char)tdata[i+j])-128;
										                        
				if(t > (div4(ref_sample)/*ref_sample>>2*/))
			    {               
			    	if(last==0)
			    		overload=0;
			    	ref_sample=ref_sample+step;//	(step+(overload*(step>>2)));
			    	sound->cdata[index+(counter>>3)] = sound->cdata[index+(counter>>3)] 
			    								| 1 << (counter %8); 
			    	overload++;
			    	last=1;							
			    }  
			    else
			    {          
			    	if(last==1)
			    		overload=0;                         
			    	if(cross)
			    		overload=0;
			    	ref_sample=ref_sample-step;//(step+(overload*(step>>2)));   
			    	sound->cdata[index+(counter>>3)] = sound->cdata[index+(counter>>3)]
			    								& ~(1 << (counter % 8));
					overload++;
			    	last=0;
			    }
				counter++;
			}             
			index=index+block_size/8;
		}   
		else
			ref_sample=0;
			               
		j=j+block_size;
	}//end while	
	//
	sound->cdata_size=index;
	
	//
	// Decompress
	//	
	ref_sample=0x0;
	index=0;
	j=0;                       
	last=0;
	overload=0;
	while(j<sound->cdata_size)
	{
		if(sound->cdata[j]==0)
		{                       
			ref_sample=0;
			//
			// Replicate Silence at current ref_sample
			//                                        
			for(i=0;i<block_size;i++)
			{

				sound->ucdata[index++]=ref_sample+128;//ref_sample;		
							
				if(post)
				{          
					if(index>1)
					{        
						prev1=sound->ucdata[index-2]; 										
						sound->ucdata[index-2]=(((unsigned char)prev)/4 + ((unsigned char)sound->ucdata[index-2])/2
							 +((unsigned char)sound->ucdata[index-1])/4);  
						prev=prev1;	 
					}
				}
			}
			//ref_sample=0;
			j++;
		}		                           
		else
		{              
			step=sound->cdata[j++];
			for(i=1;i<block_size+1;i++)
			{                  

				if(lpc)
					ref_sample =  (ref_sample>>2) + (ref_sample>>1) + 
							(ref_sample &1);
																                 								
				if(sound->cdata[j+((i-1)>>3)] & (1 << ((i-1) % 8)))
				{
					if(last==0)
						overload=0;
					ref_sample=ref_sample + step;//(step+(overload*(step>>2)));
					overload++;
					last=1;
				}                                     
				else
				{                  
					if(last==1)
						overload=0;
					ref_sample=ref_sample - step;//(step+(overload*(step>>2)));				
					overload++;
					last=0;
				} 
				//
				// clip
				//
				t=(div4(ref_sample)/*ref_sample>>2*/)+128;
        		if(t>255)
        			t=255;
        		if(t<0)
        			t=0;	
        		sound->ucdata[index++]=(unsigned char)t;
			}
			j=j+(block_size/8);
		}
	}
	sound->ucdata_size=index;      
	//
	// See if we want to post filter.
	//                               
	if(post)
	{    										
		lowpass1(sound->ucdata,index);
	}
	
	return 1;
}
    

/////////////////////////
/////////////////////////
/////////////////////////
/////////////////////////

double
snr(buff1,buff2,size)
HPSTR      	buff1;
HPSTR		buff2;
long		size;
{
double  sigma_x, sigma_e,snr;
long    i;
double  x,y;


    sigma_x = sigma_e = 0.0;
    for(i=0;i<size;i++)
    {
        x = (double)abs(buff1[i])/127;
        y = (double)abs(buff2[i])/127;
        sigma_x = sigma_x + x*x;
        sigma_e = sigma_e + (x-y)*(x-y);
    }

    sigma_x = sigma_x / (double) size;
    sigma_e = sigma_e / (double) size;

    if(sigma_e >0.0)
    {
           snr = 10.0 * log10(sigma_x/sigma_e);
           return snr;
    }
    else
		return 0;
}

